/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package ihm.iprinewsanalyzer;

import proc.cluster.Experiences;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.Timer;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.FlowLayout;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.util.Map;
import java.util.Vector;

public class TableExperiences2 extends JPanel implements Scrollable {
private JPanel[] pExperiences;
    private JLabel[] lDesc;
    private JLabel[] lDuree;
    private JScrollPane[] spResultats;
    private JTree[] tResultats;
    private JSlider[] sResultats;
    private JButton[] bRun;
    private JButton bRunAll;
    private Timer[] timerExperiences;

    public TableExperiences2() {
        int nbXP = Experiences.getExperiences().length;
        setLayout(new GridLayout(nbXP+1, 1, 5, 0));
        pExperiences = new JPanel[nbXP];
        lDesc = new JLabel[nbXP];
        lDuree = new JLabel[nbXP];
        spResultats = new JScrollPane[nbXP];
        tResultats = new JTree[nbXP];
        sResultats = new JSlider[nbXP];
        bRun = new JButton[nbXP];
        timerExperiences = new Timer[nbXP];

        bRunAll = new JButton("Lancer toutes les expériences l'une après l'autre");
        JPanel pRunAll = new JPanel(new FlowLayout());
        pRunAll.add(bRunAll);
        add(pRunAll);
        bRunAll.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ae){
                lanceExperiences();
            }
        });

        for(int i=0; i<nbXP; i++){
            pExperiences[i] = new JPanel();
            pExperiences[i].setBorder(BorderFactory.createTitledBorder(Experiences.getExperiences()[i].getTitre()));
            pExperiences[i].setLayout(new BorderLayout());
            JPanel pX = new JPanel(new BorderLayout());
            lDesc[i] = new JLabel(Experiences.getExperiences()[i].getDesc());
            pX.add(lDesc[i], BorderLayout.CENTER);
            JPanel pData = new JPanel(new BorderLayout());
            final int j = i+1;
            bRun[i] = new JButton("Lancer cette expérience");
            bRun[i].addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent arg0) {
                    lanceExperience(j);
                }
            });
            JPanel pRun = new JPanel();
            pRun.add(bRun[i]);
            pData.add(pRun, BorderLayout.NORTH);
            JPanel pData2 = new JPanel(new GridLayout(1,2));
            pData2.add(new JLabel("Durée de l'expérience : ", JLabel.RIGHT));
            lDuree[i] = new JLabel("00:00:00", JLabel.LEFT);
            pData2.add(lDuree[i]);
            pData.add(pData2, BorderLayout.SOUTH);
            pX.add(pData, BorderLayout.SOUTH);
            pExperiences[i].add(pX, BorderLayout.NORTH);

            tResultats[i] = new JTree();
            DefaultMutableTreeNode racine = new DefaultMutableTreeNode("Clusters obtenus");
            tResultats[i].setModel(new DefaultTreeModel(racine));
            spResultats[i] = new JScrollPane(tResultats[i]);
            sResultats[i] = new JSlider(JSlider.HORIZONTAL, 1, 1, 1);
            sResultats[i].setMajorTickSpacing(1);
            sResultats[i].setMinorTickSpacing(1);
            sResultats[i].setPaintTicks(true);
            sResultats[i].setPaintLabels(false);
            sResultats[i].setValueIsAdjusting(true);
            sResultats[i].addChangeListener(new ChangeListener() {

                public void stateChanged(ChangeEvent e) {
                    montreResultat(j);
                }
            });
            JPanel pX2 = new JPanel(new BorderLayout());
            pX2.add(spResultats[i], BorderLayout. CENTER);
            pX2.add(sResultats[i], BorderLayout.SOUTH);
            pExperiences[i].add(pX2, BorderLayout.CENTER);
            add(pExperiences[i]);

            timerExperiences[i] = new Timer(1000, new ActionListener(){
                public void actionPerformed(ActionEvent ae){
                    majExperience(j);
                }
            });
        }

        Charte.formateAndFormateChildren(this);
    }

    private proc.cluster.Experience[] listeExperiences = Experiences.getExperiences();
    public void completeExperiences(){
        int nbXP = Experiences.getExperiences().length;
        for(int i=0; i<nbXP; i++){
            pExperiences[i].setBorder(BorderFactory.createTitledBorder(Experiences.getExperiences()[i].getTitre()));
            lDesc[i].setText(listeExperiences[i].getDesc());
        }
    }

    private void lanceExperience(int numero){
        final int j = numero-1;
        new Thread(){
            public void run() {
                for (int i = j; i < j+1; i++) {
                    bRun[i].setText("Expérience en cours");
                    new Thread(listeExperiences[i]).start();
                    timerExperiences[i].start();
                    do {
                        try{
                            Thread.sleep(1000);
                        } catch(InterruptedException ie){

                        }
                    } while(!(listeExperiences[i].isTermine()));
                    timerExperiences[i].stop();
                    System.out.println(listeExperiences[i].getResultat().getTitre());
                    System.out.println(listeExperiences[i].getResultat().getTotalClusters());
                    sResultats[i].setMaximum(listeExperiences[i].getResultat().getTotalClusters());
                    sResultats[i].setMajorTickSpacing(sResultats[i].getMaximum()/10);
                    sResultats[i].setValue(1);
                    montreResultat(i+1);
                    //System.out.println(listeExperiences[i].getResultat());
                    bRun[i].setText("Lancer cette expérience");
                }
            }
        }.start();
    }

    private void lanceExperiences(){
        new Thread(){
            public void run() {
                int nbXP = Experiences.getExperiences().length;
                for (int i = 0; i < nbXP; i++) {
                    bRun[i].setText("Expérience en cours");
                    new Thread(listeExperiences[i]).start();
                    timerExperiences[i].start();
                    do {
                        try{
                            Thread.sleep(1000);
                        } catch(InterruptedException ie){

                        }
                    } while(!(listeExperiences[i].isTermine()));
                    timerExperiences[i].stop();
                    System.out.println(listeExperiences[i].getResultat().getTitre());
                    sResultats[i].setMaximum(listeExperiences[i].getResultat().getTotalClusters());
                    sResultats[i].setMajorTickSpacing(sResultats[i].getMaximum()/10);
                    sResultats[i].setValue(1);
                    montreResultat(i+1);
                    bRun[i].setText("Lancer cette expérience");
                }
            }
        }.start();
    }

    private void montreResultat(int numero){
        int nbClustersAMontrer = sResultats[numero-1].getValue();
        Map<String, String[]> liste = listeExperiences[numero-1].getResultat().aplanis(nbClustersAMontrer);
        DefaultMutableTreeNode racine = new DefaultMutableTreeNode("Clusters obtenus");
        Vector<String> c = new Vector(liste.keySet());
        for(int i=0; i<c.size(); i++){
            String[] s = liste.get(c.elementAt(i));
            DefaultMutableTreeNode fils = new DefaultMutableTreeNode(c.elementAt(i));
            for(int j=0; j<s.length; j++){
                fils.add(new DefaultMutableTreeNode(s[j]));
            }
            racine.add(fils);
        }
        tResultats[numero-1].setModel(new DefaultTreeModel(racine));
        for(int i=0; i<tResultats[numero-1].getRowCount(); i++){
            tResultats[numero-1].expandRow(i);
        }
    }

    private void majExperience(int numero){
        int elapsed = listeExperiences[numero-1].getSecondesExecution();
        String hr = "" + (elapsed / 3600);
        if (hr.length() < 2) {
            hr = "0" + hr;
        }
        String mn = "" + (elapsed % 3600 / 60);
        if (mn.length() < 2) {
            mn = "0" + mn;
        }
        String s = "" + (elapsed % 60);
        if (s.length() < 2) {
            s = "0" + s;
        }
        lDuree[numero-1].setText(hr+":"+mn+":"+s);
        bRun[numero-1].setText(listeExperiences[numero-1].getStatut());
        if(listeExperiences[numero-1].isTermine()){
            timerExperiences[numero-1].stop();
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return 10 * 60;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 60;
    }
}
